﻿using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using ServiceStackAndHTML.Model;

namespace ServiceStackAndHTML.DTO
{
    [DataContract]
    public class MoviesResponse
    {
        private readonly Movie[] goodMovies;
        private readonly Movie[] poorMovies;

        public MoviesResponse()
            : this(Enumerable.Empty<Movie>())
        {
        }

        public MoviesResponse(IEnumerable<Movie> allMovies)
        {
            this.goodMovies = allMovies.Where(m => !m.IsPoor).ToArray();
            this.poorMovies = allMovies.Where(m => m.IsPoor).ToArray();
        }

        [DataMember]
        public Movie[] GoodMovies
        {
            get { return goodMovies; }
        }

        [DataMember]
        public Movie[] PoorMovies
        {
            get { return poorMovies; }
        }
    }
}