﻿using System.Collections.Generic;
using System.Linq;
using ServiceStack.ServiceInterface;
using ServiceStackAndHTML.DTO;
using ServiceStackAndHTML.Model;

namespace ServiceStackAndHTML.Services
{
    // [DefaultView("content")]
    public class MovieService : Service
    {
        private static List<Movie> movies = new List<Movie>();

        static MovieService()
        {
            movies.AddRange(new[]
            {
                new Movie {Title = "Star Wars: The Force Awakens", IsPoor = false},
                new Movie {Title = "Star Wars: The Empire Strikes Back", IsPoor = false},
                new Movie {Title = "Star Wars: The Phantom Menace", IsPoor = true}
            }
                );
        }

        public MoviesResponse Get(MoviesRequest request)
        {
            return new MoviesResponse(movies);
        }

        public MoviesResponse Post(MoviesRequest request)
        {
            movies.Add(new Movie
            {
                Title = request.Title, 
                IsPoor = request.IsPoor.Value
            });
            return new MoviesResponse(movies);
        }

        public MoviesResponse Delete(MoviesRequest request)
        {
            movies = movies.Where(m => !(m.Title == request.Title && m.IsPoor == request.IsPoor))
                .ToList();

            return new MoviesResponse(movies);
        }
    }
}