﻿using System;

using UIKit;
using CoreMotion;

namespace Pedometer
{
    public partial class PedoController : UIViewController
    {
        UILabel uil, uilNow;
        CoreMotion.CMPedometer cmp;
        public PedoController() : base("PedoController", null)
        {
        }

        public override void DidReceiveMemoryWarning()
        {
            base.DidReceiveMemoryWarning();

            // Release any cached data, images, etc that aren't in use.
        }

		public override void ViewDidLoad()
		{
			base.ViewDidLoad();
			uil = new UILabel();
			var vwFrame = this.View.Frame;
			uil.Frame = new CoreGraphics.CGRect(10.0, 50.0, vwFrame.Width - 20.0, 25.0);
			this.View.Add(uil);
			uilNow = new UILabel();
			uilNow.Frame = new CoreGraphics.CGRect(10, 85.0, vwFrame.Width - 20.0, 25);
			this.View.Add(uilNow);
			cmp = new CoreMotion.CMPedometer();
		}
		public override async void ViewDidAppear(bool animated)
		{
			base.ViewDidAppear(animated);

			if (CoreMotion.CMPedometer.IsPedometerEventTrackingAvailable)
			{
				cmp.StartPedometerUpdates(new Foundation.NSDate(), handlePedoUpdates);

				var pedData = await cmp.QueryPedometerDataAsync((new Foundation.NSDate()).AddSeconds(-86400), new Foundation.NSDate());
				uil.Text = String.Format("Last 24 hours: {0}", pedData.NumberOfSteps);
			}
		}
		public override void ViewDidDisappear(bool animated)
		{
			base.ViewDidDisappear(animated);
			if (CoreMotion.CMPedometer.IsPedometerEventTrackingAvailable)
			{
				cmp.StopPedometerUpdates();
			}
		}
		private void handlePedoUpdates(CMPedometerData data, Foundation.NSError error)
	        {
	            if(error == null)
	            {
	                InvokeOnMainThread(() => {
						uilNow.Text = String.Format("Pace: {0}", data.CurrentPace);
	                });
	            }
        	}
    }
}