# Modernizing Traditional .NET Apps with Docker

This code accompanies the MSDN Article. It requires Docker to build and run images, and Visual Studio 2015 if you also want to compile the source code.

- on Windows 10, [Docker for Windows](https://docs.docker.com/docker-for-windows/) is a single-step installation of Docker and Docker Compose
- on Windows Server 2016 follow the [quick-start tutorial](https://docs.microsoft.com/en-us/virtualization/windowscontainers/quick-start/quick-start-windows-server#1-install-docker) to install Docker, and then download the latest release of Docker Compose - currently [1.10.1](https://github.com/docker/compose/releases/download/1.10.1/docker-compose-Windows-x86_64.exe).


## Version 1

Version 1 of the app takes an ASP.NET website and packages it into a Docker image without changing the code. You can build the application and the Docker image yourself by running `build.ps1` in the `version-1\docker` directory. Or you can run the solution from the published images on Docker Hub by running `run.ps1`.

When the application is running, use this command to get the IP address of the web container:

```
docker inspect --format '{{ .NetworkSettings.Networks.nat.IPAddress }}' web
```

You can browse to that IP address and see the website running, and fill in some details on the registration form, which the app saves in SQL Server. You can grab the IP address of the SQL Server container in the same way:

```
docker inspect --format '{{ .NetworkSettings.Networks.nat.IPAddress }}' sql-server
```

Then you can connect to SQL inside the container (with SSMS, or Visual Studio) to query the database.


## Version 2

Version 2 of the app extracts the synchronous database calls into an aysnchronous message handler, using [NATS](https://nats.io) as the message queue. As before, build the solution with `build.ps1` in the `version-2\docker` directory, and/or run it with `docker-compose up -d` from the same directory.

The container will have a different name from version 1, so you get the IP address with:

```
docker inspect --format '{{ .NetworkSettings.Networks.nat.IPAddress }}' docker_product-launch-web_1
```

The user behavior is the same, but now when you submit the form the data is published as an event to the message queue, and the message handler picks up the event and actions it. You can see all the containers running with `docker ps`, and monitor the activity in a container with `docker top <id>` and `docker logs <id>`.


## Version 3

Version 3 of the app adds analytics to the existing solution, with an additional message handler listening for the same event published in version 2. The new handler indexes the user data in [Elasticsearch](https://www.elastic.co/products/elasticsearch), and the Docker solution includes a [Kibana](https://www.elastic.co/products/kibana) container for self-service analytics.

You can build the solution with `build.ps1` in the `version-3\docker` directory, and/or run it with `docker-compose up -d` from the same directory.

As in version 2, you can get the IP address of the container named `docker_product-launch-web_1` to browse to the website. Now you can also get the IP address of the Kibana container named `docker_kibana_1`, and browse to port `5601` on that container to see Kibana. On the startup page, enter `prospects` as the index name, and Kibana will show you all the data stored in Elasticsearch.
