Imports ProductLaunch.Entities
Imports System.Data.Entity

Namespace ProductLaunch.Model.Initializers
	Public Class StaticDataInitializer
		Inherits CreateDatabaseIfNotExists(Of ProductLaunchContext)

		Protected Overrides Sub Seed(ByVal context As ProductLaunchContext)
			AddRole(context, "DA", "Developer Advocate")
			AddRole(context, "DM", "Decision Maker")
			AddRole(context, "AC", "Architect")
			AddRole(context, "EN", "Engineer")
			AddRole(context, "OP", "IT Ops")

			AddCountry(context, "GBR", "United Kingdom")
			AddCountry(context, "USA", "United States")
			AddCountry(context, "SWE", "Sweden")

			context.SaveChanges()
		End Sub

		Private Sub AddCountry(ByVal context As ProductLaunchContext, ByVal code As String, ByVal name As String)
			context.Countries.Add(New Country With {.CountryCode = code, .CountryName = name})
		End Sub

		Private Sub AddRole(ByVal context As ProductLaunchContext, ByVal code As String, ByVal name As String)
			context.Roles.Add(New Role With {.RoleCode = code, .RoleName = name})
		End Sub
	End Class
End Namespace
