Imports ProductLaunch.Entities
Imports ProductLaunch.Model
Imports System.Web.UI
Imports System.Web.UI.WebControls

Namespace ProductLaunch.Web
	Partial Public Class SignUp
		Inherits Page

		Private Shared _Countries As Dictionary(Of String, Country)
		Private Shared _Roles As Dictionary(Of String, Role)

		Public Shared Sub PreloadStaticDataCache()
			_Countries = New Dictionary(Of String, Country)
			_Roles = New Dictionary(Of String, Role)
			Using context = New ProductLaunchContext
				For Each country In context.Countries.OrderBy(Function(x) x.CountryName)
					_Countries(country.CountryCode) = country
				Next country
				For Each role In context.Roles.OrderBy(Function(x) x.RoleName)
					_Roles(role.RoleCode) = role
				Next role
			End Using
		End Sub

		Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
			If Not Page.IsPostBack Then
				PopulateRoles()
				PopulateCountries()
			End If
		End Sub

		Private Sub PopulateRoles()
			ddlRole.Items.Clear()
			ddlRole.Items.AddRange(_Roles.Select(Function(x) New ListItem(x.Value.RoleName, x.Key)).ToArray)
		End Sub

		Private Sub PopulateCountries()
			ddlCountry.Items.Clear()
			ddlCountry.Items.AddRange(_Countries.Select(Function(x) New ListItem(x.Value.CountryName, x.Key)).ToArray)
		End Sub

		Protected Sub btnGo_Click(ByVal sender As Object, ByVal e As EventArgs)
			Dim country = _Countries(ddlCountry.SelectedValue)
			Dim role = _Roles(ddlRole.SelectedValue)

			Dim prospect = New Prospect With {.CompanyName = txtCompanyName.Text, .EmailAddress = txtEmail.Text, .FirstName = txtFirstName.Text, .LastName = txtLastName.Text, .Country = country, .Role = role}

			Using context = New ProductLaunchContext
				'reload child objects:
				prospect.Country = context.Countries.Single(Function(x) x.CountryCode = prospect.Country.CountryCode)
				prospect.Role = context.Roles.Single(Function(x) x.RoleCode = prospect.Role.RoleCode)

				context.Prospects.Add(prospect)
				context.SaveChanges()
			End Using

			Server.Transfer("ThankYou.aspx")
		End Sub
	End Class
End Namespace
