Imports NATS.Client
Imports ProductLaunch.Messaging
Imports ProductLaunch.Messaging.Messages.Events
Imports ProductLaunch.Model
Imports System.Threading

Namespace ProductLaunch.MessageHandlers.SaveProspect
	Friend Class Program
		Private Shared _ResetEvent As New ManualResetEvent(False)

		Shared Sub Main(ByVal args() As String)
			Console.WriteLine($"Connecting to message queue url: {MessageQueue.MessageQueueUrl}")
			Using connection = MessageQueue.CreateConnection
				Dim subscription = connection.SubscribeAsync(ProspectSignedUpEvent.MessageSubject)
				AddHandler subscription.MessageHandler, AddressOf SaveProspect
				subscription.Start()
				Console.WriteLine($"Listening on subject: {ProspectSignedUpEvent.MessageSubject}")

				_ResetEvent.WaitOne()
				connection.Close()
			End Using
		End Sub

		Private Shared Sub SaveProspect(ByVal sender As Object, ByVal e As MsgHandlerEventArgs)
			Console.WriteLine($"Received message, subject: {e.Message.Subject}")
			Dim eventMessage = MessageHelper.FromData(Of ProspectSignedUpEvent)(e.Message.Data)
			Console.WriteLine($"Saving new prospect, signed up at: {eventMessage.SignedUpAt}; event ID: {eventMessage.CorrelationId}")

			Dim prospect = eventMessage.Prospect
			Using context = New ProductLaunchContext
				'reload child objects:
				prospect.Country = context.Countries.Single(Function(x) x.CountryCode = prospect.Country.CountryCode)
				prospect.Role = context.Roles.Single(Function(x) x.RoleCode = prospect.Role.RoleCode)

				context.Prospects.Add(prospect)
				context.SaveChanges()
			End Using

			Console.WriteLine($"Prospect saved. Prospect ID: {eventMessage.Prospect.ProspectId}; event ID: {eventMessage.CorrelationId}")
		End Sub
	End Class
End Namespace
