Imports Nest
Imports ProductLaunch.MessageHandlers.IndexProspect.Documents

Namespace ProductLaunch.MessageHandlers.IndexProspect.Indexer
	Public Class Index
		Public Const ElasticsearchUrl As String = "http://elasticsearch:9200"

		Public Shared Sub Setup()
			Dim node = New Uri(ElasticsearchUrl)
			Dim settings = New ConnectionSettings(node)
			Dim client = New ElasticClient(settings)
			client.CreateIndex("prospects")
		End Sub

		Public Shared Sub CreateDocument(ByVal prospect As Prospect)
			Try
				Dim node = New Uri(ElasticsearchUrl)
				Dim client = New ElasticClient(node)
				client.Index(prospect, Function(idx) idx.Index("prospects"))
			Catch ex As Exception
				Console.WriteLine($"Index prospect FAILED, email address: {prospect.EmailAddress}, ex: {ex}")
			End Try
		End Sub
	End Class
End Namespace
