Imports NATS.Client
Imports ProductLaunch.MessageHandlers.IndexProspect.Indexer
Imports ProductLaunch.Messaging
Imports ProductLaunch.Messaging.Messages.Events
Imports System.Threading

Namespace ProductLaunch.MessageHandlers.IndexProspect
	Friend Class Program
		Private Shared _ResetEvent As New ManualResetEvent(False)

		Shared Sub Main(ByVal args() As String)
			Console.WriteLine($"Initializing Elasticsearch.")
			Index.Setup()

			Console.WriteLine($"Connecting to message queue url: {MessageQueue.MessageQueueUrl}")
			Using connection = MessageQueue.CreateConnection
				Dim subscription = connection.SubscribeAsync(ProspectSignedUpEvent.MessageSubject)
				AddHandler subscription.MessageHandler, AddressOf IndexProspect
				subscription.Start()
				Console.WriteLine($"Listening on subject: {ProspectSignedUpEvent.MessageSubject}")

				_ResetEvent.WaitOne()
				connection.Close()
			End Using
		End Sub

		Private Shared Sub IndexProspect(ByVal sender As Object, ByVal e As MsgHandlerEventArgs)
			Console.WriteLine($"Received message, subject: {e.Message.Subject}")
			Dim eventMessage = MessageHelper.FromData(Of ProspectSignedUpEvent)(e.Message.Data)
			Console.WriteLine($"Indexing prospect, signed up at: {eventMessage.SignedUpAt}; event ID: {eventMessage.CorrelationId}")

			Dim prospect = New Documents.Prospect With {.CompanyName = eventMessage.Prospect.CompanyName, .CountryName = eventMessage.Prospect.Country.CountryName, .EmailAddress = eventMessage.Prospect.EmailAddress, .FullName = $"{eventMessage.Prospect.FirstName} {eventMessage.Prospect.LastName}", .RoleName = eventMessage.Prospect.Role.RoleName, .SignUpDate = eventMessage.SignedUpAt}
			Index.CreateDocument(prospect)

			Console.WriteLine($"Prospect indexed; event ID: {eventMessage.CorrelationId}")
		End Sub
	End Class
End Namespace
