Imports NATS.Client
Imports ProductLaunch.Messaging.Messages

Namespace ProductLaunch.Messaging
	Public NotInheritable Class MessageQueue
		Public Const MessageQueueUrl As String = "nats://message-queue:4222"

        Public Shared Sub Publish(Of TMessage As Message)(ByVal message As TMessage)
			Using connection = CreateConnection()
				Dim data = MessageHelper.ToData(message)
				connection.Publish(message.Subject, data)
			End Using
		End Sub

        Public Shared Function CreateConnection() As IConnection
            Dim connect As New ConnectionFactory
            Return connect.CreateConnection(MessageQueueUrl)
        End Function
    End Class
End Namespace
