Imports ProductLaunch.Entities
Imports System.Data.Entity

Namespace ProductLaunch.Model
	Public Class ProductLaunchContext
		Inherits DbContext

		Public Sub New()
			MyBase.New("ProductLaunchDb")
		End Sub

		Public Property Countries As DbSet(Of Country)

		Public Property Roles As DbSet(Of Role)

		Public Property Prospects As DbSet(Of Prospect)

		Protected Overrides Sub OnModelCreating(ByVal builder As DbModelBuilder)
			builder.Entity(Of Country)().HasKey(Function(c) c.CountryCode)
			builder.Entity(Of Role)().HasKey(Function(r) r.RoleCode)
			builder.Entity(Of Prospect)().HasOptional(Of Country)(Function(p) p.Country)
			builder.Entity(Of Prospect)().HasOptional(Of Role)(Function(p) p.Role)
		End Sub
	End Class
End Namespace
