﻿using Microsoft.AspNet.Mvc;
using MvcSample.Web.Models;

namespace MvcSample.Web
{
    public class HomeController : Controller
    {
        public IActionResult Index(string successMessage)
        {
            ViewBag.Success = successMessage;
            return View(new User());
        }

        public IActionResult CreateUser(User model)
        {
            if (ModelState.IsValid)
            {
                return RedirectToAction("Index", "Home", new { successMessage = "Success" });
            }
            return View("Index", model);
        }
    }
}