﻿using Microsoft.AspNet.Razor.Runtime.TagHelpers;

namespace HelloMvc.TagHelpers
{
    [HtmlTargetElement("bs-select", Attributes = "data-url, search,  asp-for")]
    public class BootstrapSelectTagHelper : TagHelper
    {
        public string DataUrl { get; set; }
        public bool Search { get; set; }
        public string AspFor { get; set; }

        public override void Process(TagHelperContext context, TagHelperOutput output)
        {
            output.TagName = "select";
            output.Attributes.Add("class", "selectpicker form-control");
            output.Attributes.Add("data-url", DataUrl);
            output.Attributes.Add("data-live-search", Search);
            output.Attributes.Add("name", AspFor);
            output.Attributes.Add("id", AspFor);
        }
    }
}
