﻿using AngularPlayground.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.SessionState;

namespace AngularPlayground.Controllers
{
   public class HomeController : Controller
   {

      public ActionResult Index()
      {
         
         return View();
      }

      public ActionResult GetCustomers()
      {
         CustomerOrdersContext db;
         db = new CustomerOrdersContext();
         var custs = db.Customers.ToList();
         return Json(custs,JsonRequestBehavior.AllowGet);
      }

      public ActionResult postCustomer(Customer newCust)
      {
         CustomerOrdersContext db;
         db = new CustomerOrdersContext();
         Customer oldCust;
         oldCust = (from c in db.Customers
                    where c.Id == newCust.Id
                    select c).FirstOrDefault();
         if (oldCust == null)
         {
            db.Customers.Add(newCust);
         }
         else
         {
            oldCust.LastName = newCust.LastName;
         }
         db.SaveChanges();
         return Content("Changes Saved");
      }

   }
}