﻿import { Component } from '@angular/core';
import { Http, Response } from '@angular/http';
import { Observable } from 'rxjs/Rx';
import 'rxjs/add/operator/map';
import { Injectable } from '@angular/core';

import { Customer } from './Customer.data'

@Injectable()
export class CustomerServiceProvider {
   private getUrl: string = "/home/GetCustomers";
   private postUrl: string = "/home/PostCustomer";

   constructor(private http: Http) { }

   getCustomers(): Observable<Customer[]> {
      var resps: Observable<Response>;
      resps = this.http.get(this.getUrl);
      var custs: Observable<Customer[]>
      custs = resps.map<Response, Customer[]>(resp => resp.json());
      return custs
   }

   updateCustomer(cust: Customer): Observable<Response> {
      var res: Observable<Response>;

      res = this.http.post(this.postUrl, cust); 
      return res;
   }
}
