System.register(["@angular/core", "./Customer.data", "./Customer.services"], function (exports_1, context_1) {
    "use strict";
    var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    };
    var __metadata = (this && this.__metadata) || function (k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
    };
    var __moduleName = context_1 && context_1.id;
    var core_1, Customer_data_1, Customer_services_1, CustomerListComponent;
    return {
        setters: [
            function (core_1_1) {
                core_1 = core_1_1;
            },
            function (Customer_data_1_1) {
                Customer_data_1 = Customer_data_1_1;
            },
            function (Customer_services_1_1) {
                Customer_services_1 = Customer_services_1_1;
            }
        ],
        execute: function () {
            CustomerListComponent = (function () {
                function CustomerListComponent(CustomerService) {
                    this.CustomerService = CustomerService;
                    this.scust = new Customer_data_1.Customer();
                    this.customers = [];
                }
                CustomerListComponent.prototype.ngOnInit = function () {
                    var _this = this;
                    this.CustomerService.getCustomers().subscribe(function (custs) { return _this.customers = custs; });
                };
                CustomerListComponent.prototype.CustomerSelected = function (custId) {
                    this.scust = this.customers.filter(function (cust) { return cust.Id == custId; })[0];
                };
                CustomerListComponent.prototype.SaveCustomer = function () {
                    this.CustomerService.updateCustomer(this.scust).subscribe(function (msg) { return alert(msg.statusText); });
                };
                CustomerListComponent.prototype.onSelected = function (count) {
                    alert(count);
                };
                return CustomerListComponent;
            }());
            CustomerListComponent = __decorate([
                core_1.Component({
                    selector: 'CustomerList',
                    template: "<h1>Customer List</h1>\n              <select (change)=\"CustomerSelected($event.target.value)\">\n                <option disabled value=\"-1\"> Select a Customer </option>\n                <option *ngFor=\"let cust of customers\" value=\"{{cust.Id}}\" >{{cust.FirstName}} {{cust.LastName}}</option>\n              </select>\n\n               <h2>Customer Information</h2>\n              <input id=\"LastName\" type=\"text\" [(ngModel)]=\"scust.LastName\"/> \n              <input type= \"button\" value=\"Save Changes\" (click)=\"SaveCustomer()\"/>\n               <span phvisDisplayCustomers=\"{{customers.length}}\" \n                     selectionType=\"multiple\" \n                     (selected)=\"onSelected($event)\" > </span>",
                    providers: [Customer_services_1.CustomerServiceProvider]
                }),
                __metadata("design:paramtypes", [Customer_services_1.CustomerServiceProvider])
            ], CustomerListComponent);
            exports_1("CustomerListComponent", CustomerListComponent);
        }
    };
});
//# sourceMappingURL=CustomerList.component.js.map