﻿import { Component, OnInit } from '@angular/core';
import { Response } from '@angular/http';

import { Customer } from './Customer.data'
import { CustomerServiceProvider } from './Customer.services'

@Component({
   selector: 'CustomerList',
   template: `<h1>Customer List</h1>
              <select (change)="CustomerSelected($event.target.value)">
                <option disabled value="-1"> Select a Customer </option>
                <option *ngFor="let cust of customers" value="{{cust.Id}}" >{{cust.FirstName}} {{cust.LastName}}</option>
              </select>

               <h2>Customer Information</h2>
              <input id="LastName" type="text" [(ngModel)]="scust.LastName"/> 
              <input type= "button" value="Save Changes" (click)="SaveCustomer()"/>
               <span phvisDisplayCustomers="{{customers.length}}" 
                     selectionType="multiple" 
                     (selected)="onSelected($event)" > </span>`,
   providers: [CustomerServiceProvider]
})
export class CustomerListComponent implements OnInit {
   customers: Customer[];
   scust: Customer;

   constructor(private CustomerService: CustomerServiceProvider) {
      this.scust = new Customer();
      this.customers = [];
   }

   ngOnInit() {
      this.CustomerService.getCustomers().subscribe(custs => this.customers = custs);
   }

   CustomerSelected(custId: number) {
      this.scust = this.customers.filter(cust => cust.Id == custId)[0];
   }

   SaveCustomer() {
      this.CustomerService.updateCustomer(this.scust).subscribe((msg: Response) => alert(msg.statusText));
   }

   onSelected(count: number) {
      alert(count);
   }
}