﻿import { Directive, ElementRef, Renderer, Input, OnInit, HostListener, Output, EventEmitter} from "@angular/core";
import { Customer } from './Customer.data'

@Directive({ selector: '[phvisDisplayCustomers]' })
export class DisplayCustomersDirective {
   @Input() selectionType: string;
   @Input("phvisDisplayCustomers") custLength: number;

   @Output() selected = new EventEmitter<number>();
   
   constructor(private elm: ElementRef, private rnd: Renderer) { }

   ngOnInit() {
      this.rnd.setElementProperty(this.elm.nativeElement, 'innerHTML', "Hello, World " + this.selectionType);
   }

   @HostListener('click') SelectedItem() {
      this.selected.emit(this.custLength);
   }
}