﻿using System;
using System.Linq;
using Microsoft.EntityFrameworkCore;
using VSMEFMigrationsDemo.Models;

namespace VSMEFMigrationsDemo
{
    class Program
    {
        static void Main(string[] args)
        {
            using (var context = new AppContext())
            {
                context.Database.Migrate();
                Console.WriteLine("Database has been migrated");

                var newPerson = new Person()
                {
                    Email = "vogelvision@gmail.com",
                    FirstName = "Eric",
                    LastName = "Vogel"
                };
                context.Persons.Add(newPerson);

                context.SaveChanges();

                var existingPerson = context.Persons.Single(x => x.Id == 1);
                Console.WriteLine("Email was set to: " + existingPerson.Email);
            }

            Console.ReadLine();
        }
    }
}
